#[cfg(not(feature = "std"))]
use alloc::vec::Vec;
use std::ptr::NonNull;


pub(crate) fn nonnull_from_vec_data<T>(v: &mut Vec<T>) -> NonNull<T>
{
    
    unsafe { NonNull::new_unchecked(v.as_mut_ptr()) }
}






#[inline]
pub(crate) unsafe fn nonnull_debug_checked_from_ptr<T>(ptr: *mut T) -> NonNull<T>
{
    debug_assert!(!ptr.is_null());
    NonNull::new_unchecked(ptr)
}
