




#[allow(dead_code)]
#[path = "version.rs"]
mod version;
use self::version::{rustc_version, Version};

use std::env;

fn main() {
    println!("cargo:rerun-if-changed=build.rs");
    println!("cargo:rerun-if-changed=version.rs");

    let version = match rustc_version() {
        Some(version) => version,
        None => {
            if env::var_os("PORTABLE_ATOMIC_DENY_WARNINGS").is_some() {
                panic!("unable to determine rustc version")
            }
            println!(
                "cargo:warning={}: unable to determine rustc version; assuming latest stable rustc (1.{})",
                env!("CARGO_PKG_NAME"),
                Version::LATEST.minor
            );
            Version::LATEST
        }
    };

    if version.minor >= 80 {
        
        
        println!(
            "cargo:rustc-check-cfg=cfg(portable_atomic_no_alloc,portable_atomic_no_alloc_layout_extras,portable_atomic_no_core_unwind_safe,portable_atomic_no_error_in_core,portable_atomic_no_futures_api,portable_atomic_no_io_safety,portable_atomic_no_io_vec,portable_atomic_no_maybe_uninit,portable_atomic_no_min_const_generics,portable_atomic_no_track_caller,portable_atomic_no_unsafe_op_in_unsafe_fn,portable_atomic_sanitize_thread)"
        );
    }

    
    
    

    
    if !version.probe(36, 2019, 4, 14) {
        println!("cargo:rustc-cfg=portable_atomic_no_alloc");
    }
    
    if !version.probe(36, 2019, 4, 24) {
        println!("cargo:rustc-cfg=portable_atomic_no_futures_api");
    }
    
    if !version.probe(36, 2019, 4, 29) {
        println!("cargo:rustc-cfg=portable_atomic_no_io_vec");
    }
    
    if !version.probe(36, 2019, 5, 20) {
        println!("cargo:rustc-cfg=portable_atomic_no_maybe_uninit");
    }
    
    if !version.probe(44, 2020, 4, 21) {
        println!("cargo:rustc-cfg=portable_atomic_no_alloc_layout_extras");
    }
    
    if !version.probe(46, 2020, 7, 1) {
        println!("cargo:rustc-cfg=portable_atomic_no_track_caller");
    }
    
    if !version.probe(51, 2020, 12, 27) {
        println!("cargo:rustc-cfg=portable_atomic_no_min_const_generics");
    }
    
    if !version.probe(52, 2021, 3, 10) {
        println!("cargo:rustc-cfg=portable_atomic_no_unsafe_op_in_unsafe_fn");
    }
    
    if !version.probe(56, 2021, 8, 1) {
        println!("cargo:rustc-cfg=portable_atomic_no_core_unwind_safe");
    }
    
    if !version.probe(63, 2022, 6, 15) {
        println!("cargo:rustc-cfg=portable_atomic_no_io_safety");
    }
    
    if !version.probe(81, 2024, 6, 8) {
        println!("cargo:rustc-cfg=portable_atomic_no_error_in_core");
    }

    if version.nightly {
        
        let sanitize = env::var("CARGO_CFG_SANITIZE").unwrap_or_default();
        if sanitize.contains("thread") {
            println!("cargo:rustc-cfg=portable_atomic_sanitize_thread");
        }
    }
}
